package com.ElyStudio.leGaou.activities;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.adapter.QuizHistoryAdapter;
import com.ElyStudio.leGaou.databinding.ActivityQuizHistoryScreenBinding;
import com.ElyStudio.leGaou.models.GetQuizHistory;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;


import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class QuizHistoryScreen extends AppCompat {

    ActivityQuizHistoryScreenBinding binding;
    BottomSheetDialog noInternetBottomSheet,errorOccurredBottomSheet;
    public static final String TAG = "QUIZ_HISTORY_SCREEN";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityQuizHistoryScreenBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());
    }

    @Override
    protected void onStart() {
        super.onStart();
        getQuizHistory();
    }

    private void getQuizHistory(){

        if(CheckInternetConnection.isInternetConnected(QuizHistoryScreen.this))
        {
            Call<GetQuizHistory> getQuizHistoryCall = ApiController.getInstance().getApi().getQuizHistory(FirebaseAuth.getInstance().getUid());

            getQuizHistoryCall.enqueue(new Callback<GetQuizHistory>() {
                @Override
                public void onResponse(Call<GetQuizHistory> call, Response<GetQuizHistory> response) {
                    if(response.body().getStatusCode() == 0)
                    {
                        if (response.body().getQuizHistoryList() != null)
                        {
                            binding.quizHistoryRecyclerview.setLayoutManager(new LinearLayoutManager(QuizHistoryScreen.this,LinearLayoutManager.VERTICAL,false));
                            binding.quizHistoryRecyclerview.setAdapter(new QuizHistoryAdapter(response.body().getQuizHistoryList(),QuizHistoryScreen.this));
                        }

                    }
                    else
                    {
                        showErrorOccurredBottomSheet();
                    }
                }

                @Override
                public void onFailure(Call<GetQuizHistory> call, Throwable t) {
                    showErrorOccurredBottomSheet();
                    Log.d(TAG,"getQuizHistoryCall Failure = "+t.getLocalizedMessage());
                }
            });
        }
        else
        {
            showNoInternetBottomSheet();
        }


    }
    public void showNoInternetBottomSheet(){

        noInternetBottomSheet = new BottomSheetDialog(QuizHistoryScreen.this);
        View view = LayoutInflater.from(QuizHistoryScreen.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        noInternetBottomSheet.setContentView(view);

        Button contactSupportBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = noInternetBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = noInternetBottomSheet.findViewById(R.id.bottomSheetTitle);
        noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = noInternetBottomSheet.findViewById(R.id.bottomSheetSubText);
        contactSupportBtn.setVisibility(View.GONE);

        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(CheckInternetConnection.isInternetConnected(QuizHistoryScreen.this))
                {
                    noInternetBottomSheet.cancel();
                    getQuizHistory();
                }
                else
                {
                    QuizzeSnackBar.showSnackBar(QuizHistoryScreen.this,view,getResources().getString(R.string.no_internet),getResources().getColor(R.color.error));
                }
            }
        });

        bottomSheetTitle.setText(getResources().getString(R.string.no_internet));
        bottomSheetSubText.setText(getResources().getString(R.string.no_internet_sub_text));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(QuizHistoryScreen.this,R.drawable.no_conection_illustration));

        if(!QuizHistoryScreen.this.isFinishing())
        {
            noInternetBottomSheet.show();
        }

    }

    public void showErrorOccurredBottomSheet(){

        errorOccurredBottomSheet = new BottomSheetDialog(QuizHistoryScreen.this);
        View view = LayoutInflater.from(QuizHistoryScreen.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        errorOccurredBottomSheet.setContentView(view);
        errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = errorOccurredBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = errorOccurredBottomSheet.findViewById(R.id.bottomSheetTitle);
        TextView bottomSheetSubText = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSubText);

        bottomSheetTitle.setText(getResources().getString(R.string.some_error_occurred));
        bottomSheetSubText.setText(getResources().getString(R.string.error_subtext));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(QuizHistoryScreen.this,R.drawable.error_illustration));
        contactSupportBtn.setText(getResources().getString(R.string.contact_support));
        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        contactSupportBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(QuizHistoryScreen.this, SupportScreen.class));
            }
        });

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                errorOccurredBottomSheet.cancel();
                getQuizHistory();
            }
        });

        if(!QuizHistoryScreen.this.isFinishing())
        {
            errorOccurredBottomSheet.show();
        }
    }
}